# OS/2 Microsoft 6.0a Makefile for icont module

CFLAGS  = -AL -c -Oiltn -Gm -Lp -G2 -Aw
CC      = cl

HDRS=	../h/rt.h ../h/config.h ../h/define.h ../h/cpuconf.h \
	../h/monitor.h

HDRS=	..\h\define.h ..\h\config.h ..\h\typedefs.h ..\h\cstructs.h \
	..\h\proto.h ..\h\cpuconf.h tproto.h globals.h

THDRS=	trans.h tree.h tsym.h token.h

LHDRS=	..\h\sys.h ..\h\rmacros.h ..\h\rstructs.h ..\h\rexterns.h \
	..\h\rproto.h link.h

TRANS=	trans.obj tcode.obj err.obj keyword.obj tlex.obj lnklist.obj \
	   optab.obj parse.obj tsym.obj tmem.obj toktab.obj tree.obj \
	   tmain.obj util.obj tlocal.obj

LINKR=	link.obj lglob.obj lcode.obj llex.obj lmem.obj lsym.obj opcode.obj

OBJS=	$(TRANS) $(LINKR)

COMMON= ..\common\getopt.obj ..\common\long.obj  ..\common\alloc.obj \
	..\common\filepart.obj ..\common\strtbl.obj

# main program

icont:	$(OBJS)
	-link @icont.lnk
	copy icont.exe ..\..\bin

# translator files

$(TRANS):	$(HDRS) $(THDRS)

trans.obj:	../h/version.h
err.obj:	tlex.h  
keyword.obj:	../h/keyword.h
lnklist.obj:	lfile.h
optab.obj:	tlex.h
parse.obj:	../h/keyword.h
tlex.obj:	tlex.h  
toktab.obj:	tlex.h 
tsym.obj:	lfile.h 
tmain.obj:	..\h\path.h
util.obj:	link.h ..\h\fdefs.h

# linker files

$(LINKR):	$(HDRS) $(LHDRS)

link.obj:	 ../h/header.h ../h/path.h
lcode.obj:	opcode.h ../h/header.h ../h/keyword.h ../h/opdefs.h \
		  ../h/version.h
lglob.obj:	opcode.h ../h/opdefs.h ../h/version.h
llex.obj:	opcode.h ../h/opdefs.h
lsym.obj:	../h/fdefs.h
opcode.obj:	opcode.h ../h/opdefs.h
